 ; Ŀ
 ;   CM: Cloud Maker - works in either direction, allows segment undo,     
 ;   snap and ortho toggle, and transparent Zoom and Pan, automatically    
 ;   subdivides segments longer than 9 x Dimscale (see line 79).           
 ;                                                                         
 ;   Modified: if the global variable Cloud is set to a number then        
 ;   all bulge lengths will be set to that x dimscale.                     
 ;   If it is nil or any other data type they will be random lengths.      
 ;   If the variable Wcloud is set then its value x dimscale is used for   
 ;   the cloud width.                                                      
 ;                                                                         
 ;   Copyright 1993 - 1996, 2002, 2005 - 2010 by Rocket Software Ltd.      
 ;   They said it couldn't be done...no, sorry, they said it shouldn't.    
 ;                                                                         
 ;   Contains 7 related routines:                                          
 ;   Cb - draw a rectangular cloud from two corner points.                 
 ;   Cbn - draw a narrow rectangular cloud from two corner points.         
 ;   Cm - the original cloud maker.                                        
 ;   Cn - Same as CM, but makes a narrow cloud.                            
 ;   Cmr - Recloud the original cloud 11 times.  (Use with caution.)       
 ;   Cs - Draw a rectangular cloud around selected entities.               
 ;   Cx - Make an existing polyline into a cloud.                          
 ;                                                                         
 ; 

 ; Ŀ
 ;   Box - draw a polyline box by dragging the second corner.              
 ;   Takes no arguments, returns a polyline ename.                         
 ; 
 (DEFUN BOX (/ aa cc bb dd)
  (setq aa (getpoint "First corner:"))
  (if (setq cc (getcorner aa "\nOpposite corner or <Return> to specify: "))
      (progn
           (setq bb (cons (car cc) (cdr aa)))
           (setq dd (cons (car aa) (cdr cc)))
           (command "pline" aa bb cc dd "c")))
 (entlast))
 ; Ŀ
 ;   Box end.                                                              
 ; 

 ; Ŀ
 ;   ChaCha - redraw a polyline so that no segment is over a set length.   
 ;   Arguments: Enam, an entity name.                                      
 ;   Calls Lenin and Misps (external).                                     
 ;   Returns nothing.                                                      
 ; 
 (DEFUN CHACHA (enam / dimscl fixlen maxd esav entt pb pa pasav ptlis ovlst)
  (setq dimscl (misps))
  (if (and cloud (member (type cloud) '(real int)))
      (progn
           (setq fixlen t)
           (setq maxd (* cloud dimscl)))     ; bulge section length
      (progn
           (setq fixlen ())
           (setq maxd (* 9 dimscl))))        ; maximum section length
  (setq esav enam)
  (while (/= (cdr (assoc 0 (setq entt (entget (setq enam (entnext enam))))))
             "SEQEND")
         (if pa (setq pb pa))
         (setq pa (cdr (assoc 10 entt)))
         (setq pa (trans pa 0 1))           ; translate from world to current.
         (if (null pasav) (setq pasav pa))
         (if (and pa pb)
             (if fixlen
                 (setq ptlis (lennon pb pa maxd))
                 (setq ptlis (lenin pb pa maxd)))
             (setq ptlis ()))
         (if ptlis
             (setq ptlis (cons pb ptlis))
             (if pb (setq ptlis (list pb))))
         (if ptlis (setq ovlst (append ovlst ptlis))))
 ; Ŀ
 ;   Call Lenin to get the dividing points between the two endpoints.      
 ; 
  (if fixlen
      (setq ptlis (lennon pa pasav maxd))
      (setq ptlis (lenin pa pasav maxd)))
  (if ptlis
      (setq ptlis (cons pa ptlis))
      (if pa (setq ptlis (list pa))))
  (if ptlis (setq ovlst (append ovlst ptlis)))
  (command "erase" esav "")
 ; Ŀ
 ;   Draw the replacement polyline.                                        
 ; 
  (command "pline")
  (while (setq pa (car ovlst))
         (setq ovlst (cdr ovlst))
         (command pa))
  (command "c")
 (princ))
 ; Ŀ
 ;   ChaCha end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Cmxa - make a polyline into a cloud.                       
 ;   Arguments: Pln, a polyline ename.                                     
 ;              Bulge, a polyline bulge factor.                            
 ;   Calls ChaCha.  Returns a stuffed and mounted armadillo.               
 ; 
 (DEFUN CMXA (pln bulge / nname nn)
 ; Ŀ
 ;   Insert extra vertices if any of the existing ones are too far apart.  
 ; 
  (chacha pln)
  (setq pln (entlast))                                     ; get pline ename
 ; Ŀ
 ;   Apply the bulges to the segments.                                     
 ; 
  (setq nname pln)                                         ; save pline ename
  (setq nn (entget pln))                                   ; same entity
  (while (/= (cdr (assoc 0 nn)) "SEQEND")                  ; for each vertex
         (entmod (subst (cons 42 bulge) (assoc 42 nn) nn)) ; apply bulge
         (setq nn (entget (setq pln (entnext pln)))))      ; next vertex
  (entupd nname)                                           ; regen polyline
 (princ))
 ; Ŀ
 ;   Cmxa end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine CX - decide whether a point is inside or outside a pline.  
 ;   Takes the polyline ename and the test point as arguments, returns a   
 ;   string stating where it was.                                          
 ; 
 (DEFUN CX (pln pta / ints nn nname pasav pa intpt intlst pc)
 ; Ŀ
 ;   Have to check each segment to see if the test line intersects it,     
 ;   and keep a tally of the number of intersections.                      
 ;   A line exactly crossing a vertex will return an intersection for       
 ;   both segments, so keep an intersection list and ignore duplicates.    
 ; 
  (setq ints 0)
  (setq nn (entget (setq nname (entnext pln))))            ; first vertex
  (setq pasav (cdr (assoc 10 nn)))                         ; save location
  (while (/= (cdr (assoc 0 nn)) "SEQEND")
         (setq pa (cdr (assoc 10 nn)))
         (if (and pa pc (setq intpt (segtst pta pa pc)))   ; call inters finder
             (progn
                  (if (not (member intpt intlst))
                      (progn
                           (setq ints (1+ ints))
                           (setq intlst (cons intpt intlst))))))
         (setq pc pa)
         (setq nn (entget (setq nname (entnext nname)))))  ; next vertex
 ; Ŀ
 ;   Check the segment between the last vertex and the start point.        
 ; 
  (if (and pasav pc)
      (if (segtst pta pasav pc)
          (setq ints (1+ ints))))
 ; Ŀ
 ;   If there are 0 or an odd number of intersections the point is         
 ;   outside the polyline (T), otherwise it is inside ().                  
 ; 
 (if (= (/ ints 2) (/ ints 2.0)) T ()))
 ; Ŀ
 ;   CX end.                                                               
 ; 

 ; Ŀ
 ;   Layp - see if a layer is off, locked, or frozen.                      
 ;   Takes one argument, a layer name.                                     
 ;   Returns a list of conditions or nil                                   
 ; 
 (DEFUN LAYP (lanam / llist sev col stalst)
  (setq llist (tblsearch "layer" lanam))
  (setq sev (cdr (assoc 70 llist)))
  (setq col (cdr (assoc 62 llist)))
  (if (= (logand sev 1) 1) (setq stalst (list "frozen")))
  (if (= (logand sev 4) 4) (setq stalst (cons "locked" stalst)))
  (if (minusp col) (setq stalst (cons "off" stalst)))
 stalst)
 ; Ŀ
 ;   Layp end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Lennon - returns a list of points between two endpoints.   
 ;   Takes three arguments - two endpoints and an approximate distance to  
 ;   between points - this will be adjusted for the closest exact fit.     
 ; 
 (DEFUN LENNON (pa pb maxd / angg dist divs ptlis)
  (setq angg (angle pa pb))
  (setq dist (distance pa pb))
  (setq divs (fix (/ dist maxd)))
  (if (zerop divs) (setq divs 1))
  (setq maxd (/ dist divs))
  (repeat (1- divs)
         (setq pa (polar pa angg maxd))
         (setq ptlis (append ptlis (list pa))))
 ptlis)
 ; Ŀ
 ;   Lennon end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Lenin - returns a list of points between two endpoints.    
 ;   Takes three arguments - two endpoints and a maximum distance to       
 ;   allow between points.                                                 
 ; 
 (DEFUN LENIN (pa pb maxd / angg dist ptlis)
  (setq angg (angle pa pb))
  (setq dist 1)
  (while (> (distance pa pb) maxd)
         (setq dist (marx maxd))
         (setq pa (polar pa angg dist))
         (setq ptlis (append ptlis (list pa))))
 ptlis)
 ; Ŀ
 ;   Lenin end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Marx - pseudo-random number generator.                     
 ;   Takes one argument - the maximum number to return.                    
 ;   Returns a real between the maximum and one tenth thereof.             
 ;   The variable Opops must be global.                                    
 ; 
 (DEFUN MARX (maxi / dists)
  (setq dists (list 1 0.1 0.75 0.35 0.65 0.25 0.5 0.1 0.7 0.5 0.25 0.65 0.35))
  (cond ((/= (type opops) 'int)
         (setq opops 0))
        ((> opops (- (length dists) 2))
         (setq opops 0))
        (t (setq opops (1+ opops))))
 (* maxi (nth opops dists)))
 ; Ŀ
 ;   Marx end.                                                             
 ; 

 ; Ŀ
 ;   Pcx - draw a polyline box around an ss.                               
 ;   Takes one argument, an ss, if this is nil it prompts for one.         
 ;   Calls the external routines Pussy and Misps.                          
 ;   Returns a polyline ename.                                             
 ; 
 (DEFUN PCX (ss / dimsc ss mxlst xtop xbot ytop ybot)
  (setvar "osmode" 0)
  (setq dimsc (* 2 (misps)))
  (if (not pussy) (load "puss"))
 ; Ŀ
 ;   Get an ss.                                                            
 ; 
  (if (null ss)
      (progn
           (prompt "Select some entities: ")
           (setq ss (ssget))))
  (if ss
      (progn
 ; Ŀ
 ;   Get its upper X bound, lower X, upper Y, and lower Y.                 
 ; 
           (setq mxlst (pussy ss))
           (setq xtop (+ (car mxlst) dimsc))
           (setq xbot (- (cadr mxlst) dimsc))
           (setq ytop (+ (caddr mxlst) dimsc))
           (setq ybot (- (cadddr mxlst) dimsc))
 ; Ŀ
 ;   Make the polyline.                                                    
 ; 
            (command ".pline" (list xbot ybot)  ; ll
                              (list xbot ytop)  ; ul
                              (list xtop ytop)  ; ur
                              (list xtop ybot)  ; lr
                              "c"))
      (prompt "No valid entities."))
 (entlast))
 ; Ŀ
 ;   Pcx end.                                                              
 ; 

 ; Ŀ
 ;   Subroutine Plam - get points, draw a polyline.                        
 ;   Takes no arguments, doesn't call anything.  Actually it's pretty      
 ;   antisocial, but returns a pline ename.                                
 ; 
 (DEFUN PLAM (/ bapt pa plist p0 p1)
  (setq bapt "Select points, the polyline will close after a <Return>: ")
  (command "pline")
 ; Ŀ
 ;   The point acquisition/polyline draw/undo loop.                        
 ; 
  (while (setq pa (getpoint bapt))
         (initget "U")                ; accept input of a U instead of a point
         (if (= pa "U")
             (if (> (length plist) 1)
                 (progn
                      (setq plist (cdr plist))
                      (command pa))
                 (prompt "No segments left to undo.\n"))
             (progn
                  (command pa)
                  (setq plist (cons pa plist))
 ; Ŀ
 ;   The next bit overwrites in red any segments which will be subdivided. 
 ;   The progn/princ seems unneccessary, but without it the red marker     
 ;   doesn't appear the first time the routine is run.  Why this is and    
 ;   why this fix works I have no idea.                                    
 ;   Red grdraw lines disappear each time a new segment is added,          
 ;   presumably the whole pline is regenerated with each new segment.      
 ; 
                  (if (and (> (length plist) 1)
                           (> (distance (setq p0 (car plist))
                                        (setq p1 (cadr plist))) (* 9 dimscl)))
                      (progn (princ) (grdraw p0 p1 1)))))
         (setq bapt (car plist)))
 ; Ŀ
 ;   Loop end - polyline complete.                                         
 ; 
  (command "c")                                            ; close polyline
 (entlast))                                                ; return its ename
 ; Ŀ
 ;   Plam end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Segtst - see if a polyline segment intersects a line       
 ;   drawn from a point.  Takes the point and segment ends as arguments    
 ;   and returns the intersection point (if any).                          
 ;   The line must be considered to be of infinite length so that it can   
 ;   hit any segment, but the intersection must be on the segment itself   
 ;   so that all tests of nonparallel lines don't produce an intersection. 
 ;   Find the infinite length intersection, measure the distance between   
 ;   that and the start point, make the line that length and do an onseg   
 ;   test.                                                                 
 ; 
 (DEFUN SEGTST (pa segst segend / pb intrs dist)
  (setq pb (polar pa 0 100))
  (setq intrs (inters pa pb segst segend ()))
  (if intrs
     (progn
          (setq dist (1+ (distance pa intrs)))
          (setq pb (polar pa 0 dist))
          (setq intrs (inters pa pb segst segend))))
 intrs)
 ; Ŀ
 ;   Segtst end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Sido - see which way out a polyline is.                    
 ;   Takes one argument, Pln, a polyline ename.                            
 ;   Returns 1 or -1 as required to make the segments bulge away from the  
 ;   inside of the enclosed area.                                          
 ;   Calls Cx.                                                             
 ; 
 (DEFUN SIDO (pln / seg nname pa pb angg dist pta side)
 ; Ŀ
 ;   Establish a test point beside the first segment.                      
 ; 
  (setq seg (entget (setq nname (entnext pln))))           ; first vertex
  (setq pa (cdr (assoc 10 seg)))                           ; save location
  (setq seg (entget (entnext nname)))                      ; second vertex
  (setq pb (cdr (assoc 10 seg)))                           ; save location
  (setq angg (angle pa pb))                                ; segment angle
  (setq dist (distance pa pb))                             ; segment length
  (setq pta (polar pa angg (/ dist 2)))                    ; midpoint
  (setq pta (polar pta (+ angg (/ pi 2)) (/ dist 100)))    ; test point
  (setq side (cx pln pta))                                 ; outside = T
 (if side -1 1))                                           ; t = reverse bulges
 ; Ŀ
 ;   Sido end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Cm - construct clouds in several ways.                     
 ; 
 (DEFUN CM (how / bulge blip plint osmo *error* dimscl pwid clay revisp laset
                                                         acver pln typp inout)
  (setvar "cmdecho" 0)
  (setq bulge 0.9)
  (command "undo" "be")
  (setq blip (getvar "blipmode"))
  (setvar "blipmode" 0)
  (setq osmo (getvar "osmode"))
  (setvar "osmode" 0)
  (if (setq plint (getvar "plinetype"))
      (setvar "plinetype" 0))
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
  (defun *error* (shk)
   (if clay (setvar "clayer" clay))
   (if osmo (setvar "osmode" osmo))
   (if pwid (setvar "plinewid" pwid))
   (if plint (setvar "plinetype"plint))
   (if blip (setvar "blipmode" blip))
   (command "undo" "end")
   (if shk (write-line shk))
  (princ))
 ; Ŀ
 ;   Get the scale.                                                        
 ; 
  (setq dimscl (misps))
 ; Ŀ
 ;   Save and reset the pline width.                                       
 ;   Revised: if the variable Wcloud is set and is a number then its       
 ;   value for the cloud width.                                                  
 ;   Plotting of polyline widths changes with 2004, so check the version   
 ;   and set the polyline width accordingly.  This assumes that the        
 ;   change came with 2004/R16, which is probably correct.                 
 ; 
  (setq pwid (getvar "plinewid"))
  (cond ((and wcloud (member (type wcloud) '(real int)))
         (setvar "plinewid" (* wcloud dimscl)))
        ((and (setq acver (getvar "acadver"))
              (< 14 (fix (read (substr acver 1 2)))))
         (setvar "plinewid" (* 0.75 dimscl)))
        (t
         (setvar "plinewid" (* 0.25 dimscl))))
 ; Ŀ
 ;   Save the current layer name, make Revision the new current one if     
 ;   it isn't locked or frozen or off, make it if it doesn't exist.        
 ; 
  (setq clay (getvar "clayer"))
  (if (setq revisp (tblsearch "layer" "revise"))
      (setq laset (layp "revise")))
  (cond ((and (null laset) (load "malaya" ())) ; first try to do it right
         (malaya "revise"))
        ((and revisp (null laset))
         (setvar "clayer" "revise"))
        ((null laset)
         (command "layer" "m" "revise" "c" "5" "" ""))
        (laset
         (prompt (strcat "The Revise layer is " (car laset) "."))))
 ; Ŀ
 ;   If Laset is null then Revise is current, so start the cloud maker.    
 ; 
  (if (null laset)
      (progn
           (cond ((= how "box")
                  (setq pln (box)))
                 ((= how "nbox")
                  (setq bulge (* bulge 0.6))
                  (setq pln (box)))
                 ((= (type how) 'ENAME)
                  (setq pln how))
                 ((= how "draw")
                  (setq pln (plam)))
                 ((= how "existing")
                  (if (and (setq pln (entsel "Select a Polyline: "))
                           (setq pln (car pln))
                           (setq typp (cdr (assoc 0 (entget pln)))))
                      (cond ((= typp "LWPOLYLINE")
                             (command "convertpoly" "heavy" pln ""))
                            ((/= typp "POLYLINE")
                             (setq pln ())))))
                 ((= how "stuff")
                  (setq pln (pcx nil)))
                 ((= how "narrow")
                  (setq bulge (* bulge 0.6))
                  (setq pln (plam))))
           (if pln
               (progn
                    (setq inout (sido pln))
                    (cmxa pln (* bulge inout)))
               (prompt "\nBad entity selection."))))
 ; Ŀ
 ;   Close the skylights, end.                                             
 ; 
  (*error* ())
 (princ))
 ; Ŀ
 ;   Subroutine Cm end.                                                    
 ; 

 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ;   This is not a defun.                                                  
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))

 ; Ŀ
 ;   CM - the vacuum tube.                                                 
 ;   Mostly just calling functions.                                        
 ; 
 (DEFUN C:CB () (cm "box") (princ))
 (DEFUN C:CBN () (cm "nbox") (princ))
 (DEFUN C:CM () (cm "draw") (princ))
 (DEFUN C:CN () (cm "narrow") (princ))
 (DEFUN C:CMR (/ pln typp inout ss bulge)
  (command "undo" "be")
  (setq bulge 0.9)
  (setq pln (box))
  (setq inout (sido pln))
  (cmxa pln (* bulge inout))
  (repeat 11
         (setq bulge (* bulge 0.8))
         (setq ss (ssadd))
         (ssadd (entlast) ss)
         (setq pln (pcx ss))
         (setq inout (sido pln))
         (cmxa pln (* bulge inout)))
  (command "undo" "end")
 (princ))
 (DEFUN C:CS () (cm "stuff") (princ))
 (DEFUN C:CX () (cm "existing") (princ))

(princ)
